/* XOP_Main.c  - MG rev. 2003 - from NL XOP School 1996 */

//********************************************************************************************************//
// PROJECT INCLUDE 
//********************************************************************************************************//
#include "XOP_Globals.h"
#include "XOP_Main.h"

#ifdef XOP_ADDS_OPERATIONS
  #include "XOP_Operations.h"
#endif

#ifdef XOP_ADDS_FUNCTIONS
  #include "XOP_Functions.h"
#endif 

#if defined(XOP_ADDS_MENUS) || defined (XOP_ADDS_ITEMS_TO_IGOR_MENUS)
  #include "XOP_Menus.h"
#endif 

#ifdef XOP_ADDS_MODELESS_DIALOGS
  #include "XOP_ModelessDlog.h"
#endif 

//********************************************************************************************************//
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=mac68k
#endif
#ifdef _WINDOWS_
	#pragma pack(2)
#endif

//********************************************************************************************************//
// LOCAL PROTOTYPES 
//********************************************************************************************************//
#pragma mark Local Prototypes

static int   XOP_Init  (void);
static int   XOP_Quit  (void);
static int   XOP_Idle    (void);
static void  XOP_Entry   (void);


//********************************************************************************************************//
// LOCAL GLOBALS (static lg_)
//********************************************************************************************************//
#pragma mark Local Globals



//********************************************************************************************************//
//						      				CODE 
//********************************************************************************************************//

//----------------------------------------------------------------------------------------
// Routine : XOP_Init - Specific initialization.
//----------------------------------------------------------------------------------------
static int XOP_Init(void)
{
  int result = NO_ERROR;
  
  #ifdef XOP_HAS_GLOBALS  
  	result = XOP_Init_Globals();              
  	if (result) return(result);
  	
  	result = XOP_Init_Handles();  
  	if (result) return(result);
  #endif 
  
  #if defined(XOP_ADDS_MENUS) || defined (XOP_ADDS_ITEMS_TO_IGOR_MENUS)
   result = XOP_Menu_Init();              
   if (result) return(result);
  #endif 
 
  /*
    other init routines ...
  */

  return (result);             
}

//----------------------------------------------------------------------------------------
// Routine : XOP_Quit - Does any necessary cleanup before XOP is closed.
//----------------------------------------------------------------------------------------
static int XOP_Quit(void)
{
 int result = NO_ERROR;

 #if defined (XOP_ADDS_MENUS) || defined (XOP_ADDS_ITEMS_TO_IGOR_MENUS)
   XOP_Menu_Reset();              // reset all menus to default state.
 #endif 

 #ifdef XOP_ADDS_MODELESS_DIALOGS
   XOP_ModelessDlog_CloseAll();   // close all windows
 #endif

 #ifdef XOP_HAS_GLOBALS
   XOP_Dispose_Handles();         // release memory 
 #endif
 
 /*
    other cleanup routines ...
 */
 
 return (result);
 
}


#pragma mark ----------------------------

//---------------------------------------------------------------------------------------
//	Routine : XOP_Idle  
//  When XOP's "type" is set to (RESIDENT | IDLE) it receive periodic IDLE messages.
//  XOP_Idle is called each time XOP_Entry() receive a IDLE message.
//---------------------------------------------------------------------------------------  
static int XOP_Idle(void) 
{
  int result = NO_ERROR;
 
  // background routines that can be called even if Igor is not 
  // the frontmost application go here
 #ifdef CONNECTED_ON_VME
	long  	iTicks;
	char	C, *p;
#endif 


  // background routines that can be called even if Igor is not 
  // the frontmost application go here
#ifdef CONNECTED_ON_VME
 if (acquisState == RUNNING) {				// one experiment is running
	p=&C;
 	*p=(*((Byte *) PORTC))& 0x02;  		/* Mac checking the BUSY line */
	iTicks = TickCount();
	if ((iTicks >= TargetTicks)||(*p==0x02)) {			// Temps d'attente max est dpass ou buffer VNE plein...    			 
//		SUSPEND_ACQ;
		result = Vider_VME();
//		RESUME_ACQ;
		iTicks = TickCount();
		TargetTicks = iTicks + lp.AcqTime_s*60;
		//XOPSilentCommand("hist2 x_ions,y_ions,0,64,64,1,64,1,64,0,0,0,0");
		XOPSilentCommand("DoImage()");
	 }

 }
#endif
  
  if (! (GetXOPStatus() & INBACKGROUND) ) {  
     // background routines that are called only if Igor is 
     // the frontmost application go here
  }
  
  return(result);	
}

//---------------------------------------------------------------------------------------
// Routine : XOP_Entry
// This is the entry point from the host application to the XOP for all messages after 
// the INIT message.
//---------------------------------------------------------------------------------------    
static void XOP_Entry(void)
{	
	int  result  = 0;
	long message = 0;

    #ifdef XOP_ADDS_MODELESS_DIALOGS
	  if ( XOP_ModelessDlog_Message() ) {							
		  SetXOPResult(NO_ERROR);
          return;
      }
    #endif // -> #ifdef XOP_ADDS_MODELESS_DIALOGS
   
		
	message = GetXOPMessage();     // get message 

    #ifdef XOP_HAS_GLOBALS 
//		XOP_Init_Globals(); // check folders and variables 
	#endif
		
	switch ( message ) {
	
	  //############################# CMD MESSAGE ###################################
      #ifdef XOP_ADDS_OPERATIONS
		case CMD :	               // user invoked an XOP
			result = XOPs_Do();
			#ifdef AUTO_QUIT	 	
                SetXOPType(TRANSIENT); // XOP does not need to remain in memory (tell Igor we want to quit).
            #endif 	
			break;
      #endif 
      //#################### FUNCTION & FUNCADDRS MESSAGEs ###########################
      #ifdef XOP_ADDS_FUNCTIONS
		case FUNCTION  :		   // user invoked an XFunc
			result = XFuncs_Do();		
			break;
		case FUNCADDRS :           // calling method (message or direct)
			result = XFuncs_Register();
			break;
      #endif 
      //################### MENUITEM & MENUENABLE MESSAGEs ###########################
      #if defined(XOP_ADDS_MENUS) || defined (XOP_ADDS_ITEMS_TO_IGOR_MENUS)              
		case MENUITEM :								
			result = XOP_Menu_Item();
			#ifdef AUTO_QUIT	
                 SetXOPType(TRANSIENT); // XOP does not need to remain in memory (tell Igor we want to quit).
            #endif 
			break;
		case MENUENABLE :				
			result = XOP_Menu_Enable();				
			break;
      #endif 
      //############################ IDLE MESSAGE ##################################### 
      #ifdef XOP_NEEDS_IDLE
        case IDLE :              // periodic IDLE message.
            result = XOP_Idle();
            break;
      #endif 
      //########################### CLEANUP MESSAGE ###################################
      case CLEANUP :  
            result = XOP_Quit(); // do any necessary cleanup before XOP is closed.
//            CustomXOPNotice("XOP MSG : XOP closed and discarded.");   
            break;
      //########################### IGNORED MESSAGES ##################################        
 	  default  :                  
	        SetXOPResult(NO_ERROR); 
	        break;
	  //############################ OTHER MESSAGES ###################################  
	  //...
	     	
	} //  switch  	
									
	SetXOPResult((long)result);
}


//------------------------------------------------------------------------------------
// Routine : main(ioRecHandle)
// This is the initial entry point at which the host application calls XOP.
// The message sent by the host must be INIT.
// main() does any necessary initialization and then sets the XOPEntry field of the
// ioRecHandle to the address to be called for future messages.
// ioRecHandle (of type IORecHandle) is a global variable that contains all of the 
// information that Igor needs to communicate with the XOP.The type IORecHandle is 
// defined in "XOP.h".
// ---------------------------------------------------------------------------------------------- 
 
HOST_IMPORT void main(IORecHandle ioRecHandle)

{	
    int result;
    	#ifdef XOP_GLOBALS_ARE_A4_BASED
		#ifdef __MWERKS__
			// For CodeWarrior 68K XOPs.
			SetCurrentA4();							// Set up correct A4. This allows globals to work.
			SendXOPA4ToIgor(ioRecHandle, GetA4());	// And communicate it to Igor.
		#endif
	#endif
	
	XOPInit(ioRecHandle);							/* do standard XOP initialization */
	SetXOPEntry(XOP_Entry);							/* set entry point for future calls */

	#ifdef AUTO_QUIT	
       SetXOPType(TRANSIENT); // XOP does not need to remain in memory (tell Igor we want to quit).
     #endif
            
    #ifdef XOP_NEEDS_IDLE                 
	   SetXOPType((long)(RESIDENT | IDLES));   // Nota : default XOP type is RESIDENT
    #endif
    
    if (igorVersion < 200)          {          // XOP needs Igor 2.0 or later. 
	   SetXOPResult(IGOR_OBSOLETE);            // "return" error code.
	   return;
	}
	
    result = XOP_Init();   				       // specific initialization      
    if (result)  
        XOP_Quit();                            // on error, do any necessary cleanup 
//    else
//        CustomXOPNotice("XOP MSG : XOP Loaded..."); // let's tell the user that his XOP is loaded.
     
	SetXOPResult((long)result);                // "return" error code.


}

//********************************************************************************************************//
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=reset
#endif
#ifdef _WINDOWS_
	#pragma pack()
#endif
